\name{CFA}
\alias{CFA}
\title{Confirmatory Factor Analysis Without Iteration}
\description{Factor analysis is a procedure for identifying latent variables  thought to account for the correlations or covariances between observed variables. There are two approaches to factor analysis: Exploratory Factor Analysis (e.g., EFA using the \code{\link{fa}} function)  and Confirmatory Factor Analysis (CFA).  Perhaps the best way to do Confirmatory Factor Analysis is with the Laavan package's cfa function. The \code{\link{CFA}} in psych is a simple and more limited version for those who want to stay within the psych package. \code{\link{CFA}} uses the direct approach (the multiple group method) using the Spearman/Guttman approach as discussed by Dhaene and Rosseel, 2025. 
}
\usage{
CFA(r, keys = NULL, cor = "cor", use ="pairwise", n.obs = NA, weight=NULL, correct=0)
}

\arguments{
  \item{r}{A data matrix or correlation /covariance matrix}
  \item{keys}{If specified, a keys list similar to \code{\link{scoreItems}}.  Alternatively can be in lavaan syntax. See examples}
  \item{cor}{How to find the correlations: "cor" is Pearson", "cov" is covariance, 
  "tet" uses \code{\link{tetrachoric}}, "poly" uses \code{\link{polychoric}}, "mixed" uses \code{link{mixedCor}} for a mixture of tetrachorics, polychorics, Pearsons, biserials, and polyserials, Yuleb is Yulebonett, Yuleq and YuleY are the obvious Yule coefficients as appropriate}
  \item{n.obs}{Number of observations if given a correlation/covariance matrix, defaults to 100}
  \item{use}{How to treat missing data, use="pairwise" is the default".  See cor for other options.}
    \item{weight}{If not NULL, a vector of length n.obs that contains weights for each observation. The NULL case is equivalent to all cases being weighted 1.} 
   \item{correct}{correction value for 0 values in tetrachoric correlation.  See the discussion in \code{\link{tetrachoric}} for alternative values.}
}
\details{Most EFA and CFA functions use maximum likelihood functions to estimate the coefficients.  However, as Maccallum et al, and Dhaene and Rosseel (2024) point out, ML approaches are not necessarily optimal for finite (e.g., small) samples.   Confirmatory factor analysis may be done without iteration (and thus not using Maximum Likelihood procedures).  The algorithm follows that of Dhaene and Rosseel (2024) using the ``Spearman" Multiple Group Method to estimate the communalities.  This method was introduced by Guttman (1952).

\code{\link{CFA}} follows the Spearman approach for communalities discussed by Dhaene and Rosseel (2024) and described as the ``Multiple Group Method".  I use the upper case name to avoid conflicts with Lavaan. 

Guttman (1952) point out that a weighting matrix of -1, 0, and 1 times is essentially a regression model where the use of differential weights doesn't make much difference. 

}
\value{
 \item{Loadings }{Factor (Pattern)Loadings}
\item{Structure }{Structure coefficients}
\item{Phi}{Factor correlations}
}
\references{Sara Dhaene and Yves Rosseel, 2024, An Evaluation of non-iterative estimators in confirmatory factor analysis. Structural Equation Modeling (31) 1 1-13. 
doi:  10.1080/10705511.2023.2187285


Guttman. L. Multiple group methods for common-factor analysis:  their basis, computation, and interpretation. Psychometrika, 17, (2) 209-222.

H.H. Harman (1967) Modern Factor Analysis. University of Chicago Press.

MacCallum, Robert C. and Browne, Michael W. and Cai, Li  (2007) Factor analysis models as approximations. In Cudeck, Robert and MacCallum, Robert C. (Eds). Factor analysis at 100: Historical developments and future directions. Lawrence Erlbaum Associates Publishers.
}


\author{William Revelle
}
\note{Still under development.  Suggestions are very welcome.  

}

\seealso{ \code{\link{fa}} for exploratory analysis and more discussion of factor analysis in general.
}
\examples{
 #test set from Harman Table 7.1 P 116
har5 <- structure(c(1, 0.485, 0.4, 0.397, 0.295, 0.485, 1, 0.397, 0.397, 
0.247, 0.4, 0.397, 1, 0.335, 0.275, 0.397, 0.397, 0.335, 1, 0.195, 
0.295, 0.247, 0.275, 0.195, 1), dim = c(5L, 5L), dimnames = list(
    c("V1", "V2", "V3", "V4", "V5"), c("V1", "V2", "V3", "V4", 
    "V5")))

CFA(har5)   #The Harman example.

CFA(Harman_5)  #the Harman example of a Heywood case


#CFA(ability, ability.keys, cor="tet")   #for a four factor model using keys

CFA(bfi,bfi.keys)   # a five factor model

colnames(Thurstone) <- rownames(Thurstone) <- paste0("x",1:9  )   #to match lavaan syntax
model <- HS.model <- ' visual  =~ x1 + x2 + x3
              textual =~ x4 + x5 + x6
              speed   =~ x7 + x8 + x9 '
CFA(Thurstone, model, n.obs=213)  #compare with the lavaan soloution

}
\keyword{ multivariate }
\keyword{ models}